#pragma once

#include "mlp.h"
#include "yarp.h"


class cacla
{
private:
	simulator *sim;
	double gamma;
	double stepsize;

public:
	FILE *f;
	FILE *fdes;
	FILE *fActor;
	FILE *fActorDes;
	FILE *fout;
	FILE *fst;


	mlp *actor, *critic;
	gsl_vector *randomAction(unsigned int size, double maxdiff);
	gsl_vector *modifyAction(gsl_vector *action, double maxdiff);
	cacla(mlp *actor, mlp *critic, simulator *sim);
	~cacla(void);

	double learnMove(gsl_vector *targetv, gsl_vector *actionv);
	double makeMove(gsl_vector *targetv, gsl_vector *actionv);
	gsl_vector *nextArmPosition(gsl_vector *state, gsl_vector *diff);
	
	//double getReward(position targetPos, position hand_position_t);

	double getReward(gsl_vector *targetv, int action);
	double getRewardTouch(gsl_vector *targetv);
	double getRewardPoint(gsl_vector *targetv);
	double getRewardPush(gsl_vector *targetv);
	
	void critictrain();

	void learnActions();
	void performActions();
	void generateLanguageFiles();
	
};

void caclatest();
void caclaMakeTest();
void generateLanguageFiles();